<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AmountCashPartnersCurrencies extends Model 
{

    protected $table = 'amount_cash_partners_currencies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('partner_id', 'currency_id', 'amount', 'status');
    protected $visible = array('partner_id', 'currency_id', 'amount', 'status');

    public function currency()
    {
        return $this->belongsTo('App\Models\Currency', 'currency_id');
    }

    public function partner()
    {
        return $this->belongsTo('App\Models\Partner', 'partner_id');
    }

}